<?php
session_start();
require_once 'database.php';
require_once 'security.php';

// Inicializar sistema de segurança
$security = new Security($pdo);

function verificarLogin() {
    if (!isset($_SESSION['usuario_id'])) {
        header("Location: login.php");
        exit();
    }
    
    // Verificar se a sessão ainda é válida
    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > 3600)) {
        session_unset();
        session_destroy();
        header("Location: login.php?expired=1");
        exit();
    }
    
    $_SESSION['last_activity'] = time();
}

function verificarAdmin() {
    if ($_SESSION['usuario_tipo'] != 'admin') {
        header("Location: index.php");
        exit();
    }
}

function clientesProximosVencimento($pdo, $dias = 3) {
    $data_limite = date('Y-m-d', strtotime("+$dias days"));
    $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM clientes WHERE data_vencimento <= ? AND status = 'ativo' AND usuario_id = ?");
    $stmt->execute([$data_limite, $_SESSION['usuario_id']]);
    return $stmt->fetch()['total'];
}

// Headers de segurança (mais compatíveis)
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');

// Prevenir cache em páginas sensíveis
if (isset($_SESSION['usuario_id'])) {
    header('Cache-Control: no-cache, no-store, must-revalidate');
    header('Pragma: no-cache');
    header('Expires: 0');
}
?>